//===============================================================================================
// Provides a variety of help methods to manipulate elements on the HTML page
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

function isIE5() { return (navigator.appVersion.toLowerCase().indexOf("msie 5")!=-1); }
	// Returns true if the brower is IE 5.x.

//-----------------------------------------------------------------------------------------------
function getWindowHeight()
	// Returns the client area height of the current window
{
	var h=window.document.documentElement.clientHeight; // IE 6 and higher (strict mode)
	if(h<1) h=window.document.body.offsetHeight; // IE 5.5 and lower
	if(h<1) h=300;

	return h;
}

//------------------------------------------------------------------------------------------------
function getWindowWidth()
	// Returns the client area width of the current window
{
	var w=window.document.documentElement.clientWidth; // IE 6 and higher (strict mode)
	if(w<1) w=window.document.body.offsetWidth; // IE 5.5 and lower
	if(w<1) w=300;

	return w;
}

//------------------------------------------------------------------------------------------------
function setFocus( id )
	// Set input focus on the element identified by id on the page
{
	if (!id) return;
	
	var e = document.getElementById( id );
	if(e)
	{
		try
		{
			if(e.tagName=="INPUT"&&e.type=="text"&&e.value.length>0)e.select();
			e.focus();
		}
		catch(e){}	
	}	
}

//----------------------------------------------------------------------------
function isInputPopulated( id, min, max )
	// Returns true if the specified input or select element is populated
{
	var e = document.getElementById(id);
	if(!e) return false;

	switch( e.tagName.toLowerCase() )
	{
		case "input":
			if(!min) min=1;
			if( e.value.length>=min )
			{
				if( max ) return ( e.value.length<=max );
				else return true;
			}			
			return false;
			
		case "select":
			return ( e.selectedIndex>0 );
	}	
	return false;
}

//----------------------------------------------------------------------------
function appendSpacer( w, h ) { document.write( renderSpacer(w,h) ); }
	// Appends a spacer of the specified width and height

//----------------------------------------------------------------------------
function appendVSpacer( h )
	// Appends a vertical spacer of the specified height.
{
	if(!h) h = 1;
	var s = renderSpacer( 1, h );
	s += '<br>';
	
	document.write( s );
}

//----------------------------------------------------------------------------
function renderSpacer( w, h )
{
	if(!h) h = 1;
	if(!w) w = 1;
	
	return '<img src="../img/clear.gif" width="'+w+'" height="'+h+'" border="0">';
}

//----------------------------------------------------------------------------
function appendAttr( name, value )
{
	var s = ' ';
	s += name;
	s += '="';
	s += value;
	s += '"';
	
	return s;
}

//----------------------------------------------------------------------------
function show(e) { if(e) e.style.visibility="visible"; }
	// Makes the specified element visible

//----------------------------------------------------------------------------
function showById(id)
	// Makes the element identified by id visible
{
	var e=document.getElementById(id);
	if(e) e.style.visibility="visible";
}

//----------------------------------------------------------------------------
function hide(e){ if(e) e.style.visibility="hidden"; }
	// Hides the specified element...still takes up space on the page

//----------------------------------------------------------------------------
function hideById(id)
	// Hides the element identified by id...still takes up space on the page
{
	var e=document.getElementById(id);	
	if(e) e.style.visibility="hidden";
}

//----------------------------------------------------------------------------
function display(id)
	// Makes the element identified by id visible and take up space on the page
{
	var e=document.getElementById(id);	
	if(e) e.style.display="";
}

//----------------------------------------------------------------------------
function noDisplay(id)
	// Makes the element identified by id hidden and not take up space on the page
{
	var e=document.getElementById(id);
	if(e) e.style.display="none";
}

//----------------------------------------------------------------------------
function setCss(id,css)
	// Changes/Sets the css classname on the specified element
{
	if(!css)return;
	
	var e=document.getElementById(id);
	if(e) e.className=css;
}

//----------------------------------------------------------------------------
function replaceTextById( id, value )
	// Looks for an item on the page with the specified id and replaces
	// its innerHtml with the specified value
{
	if(!id) return;
	if(!value) value="";
	
	var e=document.getElementById(id);
	if(e) e.innerHTML=value;
}

//----------------------------------------------------------------------------
function taggedValue(tag,value)
	// Render a value that is surrounded by the specified tag
{
	var s = '<'+tag+'>';
	s += value;
	s += '</'+tag+'>';
	return s;	
}

//----------------------------------------------------------------------------
function toDollarString(amt)
	// Converts a number to a currency string
{
	// Round amount to 2 decimal places
	amt *= 100;
	amt = Math.round(amt);
	amt /= 100;

	// Convert to an string, ensure the string has 2 number after decimal
	var s="$";
	s += amt;
	
	var decimalPos = s.indexOf('.');
	if( -1 == decimalPos ) s += '.00'; // No decimal
	else
	{
		var cnt = 2 - ((s.length-1)-decimalPos);
		for( var i=0; i<cnt; ++i ) s += '0';
	}
	
	return s;	
}

//----------------------------------------------------------------------------
function todayString()
	// Returns today's date in a displayable string
{
	var tdy  = new Date();
	var month = tdy.getMonth() + 1;
	var s = month + '/' + tdy.getDate() + '/' + tdy.getFullYear();
	return s;
}

//-----------------------------------------------------------------------------
function imgHover(id)
{
   try
   {
	   var e = document.getElementById( id );
	   if ( e ) { e.src = e.hoverSrc; }
   } catch (e) {}    
}
function imgNormal(id)
{
   try
   {
	   var e = document.getElementById( id );
	   if ( e ) { e.src = e.normalSrc; }
   } catch (e) {}    
}
function imgDown(id)
{
   try
   {
	   var e = document.getElementById( id );
	   if ( e ) { e.src = e.downSrc; }
   } catch (e) {}    
}